(
	-- Bitmap Texture

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"b4321acb-05bf-449c-95f9-4b24240ade4f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("UV", mtl.coords) -- UVGenerator
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("visible",  mtl.coords, "visible") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #( "rgb_source",		    mtl.rgbOutput == 1 )  
			append res #( "mono_source",		mtl.monoOutput == 1 )  
			append res #( "alpha_source",		mtl.alphaSource == 1 )  
			append res #( "output_alpha",		mtl.alphaSource < 2 )  
			
			append res #( "apply",				mtl.apply)  
			append res #( "place",				mtl.cropPlace == 1)  
			append res #( "u",					mtl.ClipU)  
			append res #( "v",					mtl.ClipV)  
			append res #( "w",					mtl.ClipW)  
			append res #( "h",					mtl.ClipH)  
			append res #( "random",				mtl.useJitter)  
			append res #( "jitter",				mtl.Jitter)  

			append res #("Bitmap", mtl, "bitmap")

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQANsfEKWLzQQ5ae/uofwBLfjPlP/fZBS6Yy
-- cu57tlL75zg6ybP9Z+/EsAbJhDyMVLIwY4xUsT4catzCTZcABxIUhVIgpLoZqcKT
-- 09K8eYjPexX5vwgZqGNazTfaxL0TTQXmrdq2ndMzoUIrVoJVOZBa5Ln4oAIwRGeY
-- 22u2D5bae2S+nfdRTu+rOtbrZDNpas4JVtp82f1MrDVpOWpif+jpT54Y/Efv44Vx
-- 6FH9RtowU6UBb+ZG4JZ65F2XuPlYYWZj2dxHnpqvqgx80UUdu4w2T/2qecXgFkRq
-- nzoOe5DG4SAlh46GPpP6JFe2BlZlQhTZUm663clGCSqlAYZtjXjb
-- -----END-SIGNATURE-----